﻿using System;
using Server;
using Server.Items;

namespace Server.Mobiles 
{ 
	//[CorpseName( "a lurg's corpse" )] 
	public class Lurg : Troglodyte 
	{ 		
		private bool IsMLBoss;
		
      [Constructable]
		public Lurg() : this ( true )
		{
		}
		
      [Constructable] 
		public Lurg( bool ismlboss ) : base() 
		{ 			
			IsMLBoss = ismlboss;
         Name = "a lurg";
			Hue = 0x455;
			
			SetStr( 584, 625 );
			SetDex( 163, 176 );
			SetInt( 102, 106 );
			
			SetHits( 8229 );
			SetStam( 163, 176 );
			SetMana( 102, 106 );

			SetDamage( 19, 28 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 50, 53 );
			SetResistance( ResistanceType.Fire, 45, 47 );
			SetResistance( ResistanceType.Cold, 56, 57 );
			SetResistance( ResistanceType.Poison, 50, 60 );
			SetResistance( ResistanceType.Energy, 41, 54 );

			SetSkill( SkillName.Wrestling, 122.7, 130.5 );	
			SetSkill( SkillName.Tactics, 109.3, 118.5 );
			SetSkill( SkillName.MagicResist, 72.9, 87.6 );
			SetSkill( SkillName.Anatomy, 110.5, 124.0 );
			SetSkill( SkillName.Healing, 93.6, 99.6 );
			
			if ( Paragon.ChestChance > Utility.RandomDouble() )
				PackItem( new ParagonChest( Name, 5 ) );
				
			Fame = 24000;
			Karma = -15000;

			VirtualArmor = 50;
			PackItem( new RandomTalisman() );
			PackItem( new Tokens( Utility.RandomMinMax( 5, 15 ) ) );
			
			if ( IsMLBoss )
			   PackItem( new ParasiticPlant() );
		}
		
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }

		public override void OnKilledBy( Mobile mob )
		{
			base.OnKilledBy( mob );

			if ( IsMLBoss && Paragon.CheckArtifactChance( mob, this ) )
			{
				Paragon.GiveMLArtifactTo( mob );
			}
		}
		
		public Lurg( Serial serial ) : base( serial )
		{
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.AosSuperBoss );
		}
		
		public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.CrushingBlow;
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}